/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.noise;

import com.yungnickyoung.minecraft.bettercaves.BCConstants;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseSettings;
import com.yungnickyoung.minecraft.yungsapi.noise.FastNoise;
import com.yungnickyoung.minecraft.yungsapi.noise.INoiseLibrary;
import com.yungnickyoung.minecraft.yungsapi.noise.OpenSimplex2S;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;

public class NoiseGen {
    private final long seed;
    private final int numGenerators;
    private final NoiseSettings noiseSettings;
    private final float yCompression;
    private final float xzCompression;
    private final List<INoiseLibrary> listNoiseGens = new ArrayList<INoiseLibrary>();

    public NoiseGen(long seed, boolean isFastNoise, NoiseSettings noiseSettings, int numGenerators, float yComp, float xzComp) {
        this.seed = seed;
        this.noiseSettings = noiseSettings;
        this.numGenerators = numGenerators;
        this.yCompression = yComp;
        this.xzCompression = xzComp;
        this.initializeNoiseGens(isFastNoise);
    }

    private double[][] generateNoiseColumn(int x, int z, int bottomY, int topY) {
        double[][] noiseColumn = new double[topY - bottomY + 1][this.numGenerators];
        for (int y = bottomY; y <= topY; ++y) {
            double[] noiseVals = new double[this.numGenerators];
            for (int i = 0; i < this.numGenerators; ++i) {
                noiseVals[i] = this.listNoiseGens.get(i).GetNoise((float)x * this.xzCompression, (float)y * this.yCompression, (float)z * this.xzCompression);
            }
            noiseColumn[y - bottomY] = noiseVals;
        }
        return noiseColumn;
    }

    public double[][][][] interpolateNoiseCube(class_2338 startPos, class_2338 endPos, int bottomY, int topY) {
        float endCoeff;
        float startCoeff;
        int x;
        int startX = startPos.method_10263();
        int endX = endPos.method_10263();
        int startZ = startPos.method_10260();
        int endZ = endPos.method_10260();
        int subChunkSize = endX - startX + 1;
        double[][] noisesX0Z0 = this.generateNoiseColumn(startX, startZ, bottomY, topY);
        double[][] noisesX0Z1 = this.generateNoiseColumn(startX, endZ, bottomY, topY);
        double[][] noisesX1Z0 = this.generateNoiseColumn(endX, startZ, bottomY, topY);
        double[][] noisesX1Z1 = this.generateNoiseColumn(endX, endZ, bottomY, topY);
        double[][][][] cube = new double[subChunkSize][subChunkSize][topY - bottomY + 1][this.numGenerators];
        cube[0][0] = noisesX0Z0;
        cube[0][subChunkSize - 1] = noisesX0Z1;
        cube[subChunkSize - 1][0] = noisesX1Z0;
        cube[subChunkSize - 1][subChunkSize - 1] = noisesX1Z1;
        for (x = 1; x < subChunkSize - 1; ++x) {
            int i;
            int y;
            startCoeff = BCConstants.START_COEFFS[x];
            endCoeff = BCConstants.END_COEFFS[x];
            for (y = bottomY; y <= topY; ++y) {
                for (i = 0; i < this.numGenerators; ++i) {
                    cube[x][0][y - bottomY][i] = cube[0][0][y - bottomY][i] * (double)startCoeff + cube[subChunkSize - 1][0][y - bottomY][i] * (double)endCoeff;
                }
            }
            for (y = bottomY; y <= topY; ++y) {
                for (i = 0; i < this.numGenerators; ++i) {
                    cube[x][subChunkSize - 1][y - bottomY][i] = cube[0][subChunkSize - 1][y - bottomY][i] * (double)startCoeff + cube[subChunkSize - 1][subChunkSize - 1][y - bottomY][i] * (double)endCoeff;
                }
            }
        }
        for (x = 0; x < subChunkSize; ++x) {
            for (int z = 1; z < subChunkSize - 1; ++z) {
                startCoeff = BCConstants.START_COEFFS[z];
                endCoeff = BCConstants.END_COEFFS[z];
                for (int y = bottomY; y <= topY; ++y) {
                    for (int i = 0; i < this.numGenerators; ++i) {
                        cube[x][z][y - bottomY][i] = cube[x][0][y - bottomY][i] * (double)startCoeff + cube[x][subChunkSize - 1][y - bottomY][i] * (double)endCoeff;
                    }
                }
            }
        }
        return cube;
    }

    public long getSeed() {
        return this.seed;
    }

    private void initializeNoiseGens(boolean isFastNoise) {
        if (isFastNoise) {
            for (int i = 0; i < this.numGenerators; ++i) {
                FastNoise noiseGen = new FastNoise();
                noiseGen.SetSeed((int)this.seed + 1111 * (i + 1));
                noiseGen.SetFractalType(this.noiseSettings.getFractalType());
                noiseGen.SetNoiseType(this.noiseSettings.getNoiseType());
                noiseGen.SetFractalOctaves(this.noiseSettings.getOctaves());
                noiseGen.SetFractalGain(this.noiseSettings.getGain());
                noiseGen.SetFrequency(this.noiseSettings.getFrequency());
                this.listNoiseGens.add((INoiseLibrary)noiseGen);
            }
        } else {
            for (int i = 0; i < this.numGenerators; ++i) {
                OpenSimplex2S noiseGen = new OpenSimplex2S(this.seed + (long)(1111 * (i + 1)));
                noiseGen.setGain((double)this.noiseSettings.getGain());
                noiseGen.setOctaves(this.noiseSettings.getOctaves());
                noiseGen.setFrequency((double)this.noiseSettings.getFrequency());
                noiseGen.setLacunarity(2.0);
                this.listNoiseGens.add((INoiseLibrary)noiseGen);
            }
        }
    }
}

